<?php

namespace ILC\MensajeriaCenter\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Messages\BroadcastMessage;

class MensajeriaNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $notificacion;
    protected $canales;

    public function __construct($notificacion)
    {
        $this->notificacion = $notificacion;
        $this->canales = is_array($notificacion->medio) ? $notificacion->medio : [$notificacion->medio];
    }

    /**
     * Especifica los canales en los que se enviará la notificación.
     */
    public function via($notifiable)
    {
        return is_array($this->notificacion->medio) ? $this->notificacion->medio : [$this->notificacion->medio];
    }

    /**
     * Representación en la base de datos.
     */
    public function toDatabase($notifiable)
    {
        return [
            'titulo' => $this->notificacion->titulo,
            'contenido' => $this->notificacion->contenido,
            'notification_id' => $this->notificacion->id,
        ];
    }

    /**
     * Representación para WebSockets.
     */
    public function toBroadcast($notifiable)
    {
        return new BroadcastMessage([
            'titulo' => $this->notificacion->titulo,
            'contenido' => $this->notificacion->contenido,
            'notification_id' => $this->notificacion->id,
        ]);
    }

    /**
     * Representación para correo electrónico.
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject($this->notificacion->titulo)
            ->line($this->notificacion->contenido)
            ->action('Ver Notificación', url('/notifications'));
    }
}
