<?php

namespace ILC\MensajeriaCenter\Models;

use ILC\MensajeriaCenter\Database\Factories\MensajeriaLogFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;

class MensajeriaLog extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'mensajeria_center_log';

    protected $fillable = ['usuario_id', 'mensajeria_id', 'is_read'];


    protected static function newFactory(): MensajeriaLogFactory
    {
        return MensajeriaLogFactory::new();
    }
}
