<?php

namespace ILC\MensajeriaCenter\Models;

use ILC\MensajeriaCenter\Database\Factories\MensajeriaCenterFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use OwenIt\Auditing\Auditable as AuditableTrait;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Model;

class MensajeriaCenter extends Model implements Auditable
{
    use HasFactory;
    use AuditableTrait;

    protected $table = 'mensajeria_center';

    protected $fillable = [
        'creador_id',
        'titulo',
        'contenido',
        'medio',
        'roles',
        'blacklist',
        'whitelist',
        'filtros_aplicados',
        'enviar_desde',
        'terminar_hasta',
        'esta_activo',
    ];

    protected $casts = [
        'medio' => 'json',
        'roles' => 'array',
        'blacklist' => 'array',
        'whitelist' => 'array',
        'enviar_desde' => 'datetime',
        'terminar_hasta' => 'datetime',
        'esta_activo' => 'boolean',
    ];

    public function getMedioAttribute($value)
    {
        return is_array($value) ? $value : json_decode($value, true);
    }

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(
            config('mensajeria_center.user_model'),
            'mensajeria_center_user',
            'notification_id',
            'user_id'
        );
    }
    public function logs(): HasMany
    {
        return $this->hasMany(MensajeriaLog::class, 'mensajeria_id');
    }

    protected static function newFactory(): MensajeriaCenterFactory
    {
        return MensajeriaCenterFactory::new();
    }
}
