<?php

namespace ILC\MensajeriaCenter\Commands;

use ILC\MensajeriaCenter\Database\Seeders\MensajeriaCenterPermisosSeeder;
use Illuminate\Console\Command;
use Spatie\Permission\Models\Permission;

class InstallMensajeriaCenterCommand extends Command
{
    public $signature = 'mensajeria_center:install';

    public $description = 'Mensajeria Center instalación';

    public function handle(): int
    {
        $this->comment('Iniciando la instalación del paquete Mensajeria Center...');

        $this->call('vendor:publish', [
            '--tag' => 'mensajeria_center-config',
        ]);

        $this->call('vendor:publish', [
            '--tag' => 'mensajeria_center-migrations',
        ]);

        if ($this->confirm('¿Deseas ejecutar las migraciones ahora?', false)) {
            $this->call('migrate');
        }

        if ($this->confirm('¿Deseas ejecutar el seeder predeterminado ahora?', false)) {
            $this->call('db:seed', [
                '--class' => MensajeriaCenterPermisosSeeder::class,
            ]);
        }
        Permission::firstOrCreate(['name' => 'mensajeria-center-listar']);
        Permission::firstOrCreate(['name' => 'mensajeria-center-crear']);
        Permission::firstOrCreate(['name' => 'mensajeria-center-editar']);
        Permission::firstOrCreate(['name' => 'mensajeria-center-eliminar']);
        $this->info('¡Instalación completada!');

        return self::SUCCESS;
    }
}
