<?php

namespace ILC\MensajeriaCenter\Database\Factories;

use ILC\MensajeriaCenter\Models\MensajeriaCenter;
use ILC\MensajeriaCenter\Models\MensajeriaLog;
use Illuminate\Database\Eloquent\Factories\Factory;

class MensajeriaLogFactory extends Factory
{
    protected $model = MensajeriaLog::class;

    public function definition(): array
    {
        return [
            'usuario_id' => call_user_func(config('mensajeria_center.user_model') . '::factory'), // Obtiene el modelo dinámicamente
            'mensajeria_id' => MensajeriaCenter::factory(),
            'is_read' => $this->faker->boolean(),
        ];
    }
}
