<?php

namespace ILC\CargaArchivos\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
class DynamicCatalogRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $table = $this->route('table');
        $rules = config("cargaarchivos.validations.{$table}", []);

        if ($this->isMethod('put') || $this->isMethod('patch')) {
            $id = $this->route('id');

            foreach ($rules as $field => $ruleSet) {
                if (is_string($ruleSet) && strpos($ruleSet, 'unique:') !== false) {
                    $rules[$field] = $ruleSet . ",{$id}";
                } elseif (is_array($ruleSet)) {
                    foreach ($ruleSet as $key => $rule) {
                        if (is_string($rule) && strpos($rule, 'unique:') !== false) {
                            $rules[$field][$key] = $rule . ",{$id}";
                        }
                    }
                }
            }
        }

        return $rules;
    }

    public function messages()
    {
        return [
            'required' => 'El campo :attribute es obligatorio.',
            'string'   => 'El campo :attribute debe ser una cadena de caracteres.',
            'max'      => 'El campo :attribute no debe exceder de :max caracteres.',
            'min'      => 'El campo :attribute debe tener al menos :min caracteres.',
            'unique'   => 'El valor del campo :attribute ya ha sido registrado.',
            'integer'  => 'Validación de prueba para un entero'
        ];
    }
}
