<?php

namespace ILC\CargaArchivos\Services;

use Illuminate\Support\Facades\Log;

class SchemaService
{
    public function create(array $context): string
    {
        $properties = [];
        Log::debug($context);
        foreach($context as $type => $meta) {
            $properties[$type] = $this->getField($meta['type'], $meta);
        }

        $schemaJson = [
            'type' => 'object',
            'properties' => (object)$properties
        ];

        return json_encode($schemaJson);
    }

    protected function getField($type, $meta)
    {
        $field = [
            'type' => $meta['type'],
            'title' => $meta['title'],
            '$id' => $meta['$id'],
        ];

        if(isset($meta['layout'])) {
            $field['layout'] = $meta['layout'];
        }

        if(isset($meta['description'])) {
            $field['description'] = $meta['description'];
        }

        return $field;
    }
}
