<?php

namespace ILC\CargaArchivos\Listeners;

use ILC\CargaArchivos\Events\FileDefinitionDeleted;
use ILC\CargaArchivos\Events\FileDefinitionSaved;
use Illuminate\Events\Dispatcher;
use Illuminate\Support\Facades\Log;

class ImportFileUploadEventSubscriber
{

    public function handleFileDefinitionSaved(FileDefinitionSaved $event): void {
        Log::info('Evento "definicion-carga-guardada" fue despachado: '.$event->fileDefinition->referencia_nombre);
    }

    public function handleFileDefinitionDeleted(FileDefinitionDeleted $event): void {
        Log::info('Evento "definicion-carga-eliminada" fue despachado: '.$event->fileDefinition->referencia_nombre);
    }

    public function subscribe(Dispatcher $events): array {
        return [
            FileDefinitionSaved::class => 'handleFileDefinitionSaved',
            FileDefinitionDeleted::class => 'handleFileDefinitionDeleted',
        ];
    }
}
