<?php

/**
 * @license Apache 2.0
 */

namespace ILC\CargaArchivos\Http\Controllers;

use ILC\CargaArchivos\Services\SchemaService;
use ILC\CargaArchivos\Traits\HandlesRelatedTables;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class JsonSchemaFormController extends Controller
{
    use HandlesRelatedTables;

    protected SchemaService $schemaService;

    public function __construct(SchemaService $schemaService)
    {
        $this->schemaService = $schemaService;
    }
    public function generateSchema(Request $request)
    {
        $fields = $request->input('fields');
        Log::info($fields);
        $context = [];

        foreach ($fields as $field) {
            $context[$field['title']] = [
                '$id' => $field['$id'],
                'type' => $field['type'],
                'title' => $field['title'],
                'description' => $field['description'] ?? null,
            ];
        }

        $formGenerator = new SchemaService();
        return $this->sendResponse([ 'data' => $formGenerator->create($context) ]);
    }

    /**
     * Obtiene los campos para el JSON schema de una tabla en específico.
     *
     * @param string $table
     * @return JsonResponse
     */
    public function getFieldsForSchema(string $table): JsonResponse
    {
        return $this->sendResponse(['data' => $this->getFieldsForJsonSchema($table)]);
    }

}
