<?php

namespace App\Listeners;

use App\Events\ModelSaved;
use Illuminate\Events\Dispatcher;
use Illuminate\Support\Facades\Log;

class ModelEventSubscriber
{
    /**
     * @param ModelSaved $event
     */
    public function handleModelSaved(ModelSaved $event): void
    {
        Log::info('Evento "Modelo Guardado" fue despachado para el modelo: ' . get_class($event->model) . ', ID: ' . $event->model->id);
    }

    /**
     * @param Dispatcher $events
     * @return array
     */
    public function subscribe(Dispatcher $events): array
    {
        return [
            ModelSaved::class => 'handleModelSaved',
        ];
    }
}
