<?php

namespace ILC\CargaArchivos\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DataDefinitionResource extends JsonResource
{

    protected mixed $context;

    public function __construct($resource, $context = 'index')
    {
        parent::__construct($resource);
        $this->context = $context;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'nombre' => $this->nombre,
            'slug' => $this->referencia_nombre,
            'descripcion' => $this->descripcion,
            'tipo' => $this->tipo_archivo,
            'fecha_creacion' => $this->created_at->toDateTimeString(),
            'ultima_actualizacion' => $this->updated_at->toDateTimeString(),
        ];
    }
}
