<?php

// config for ILC/CargaArchivos
return [
    'tables' => [
        'exclude' => [
            'audits',
            'cache',
            'cache_locks',
            'failed_jobs',
            'job_batches',
            'jobs',
            'migrations',
            'model_has_permissions',
            'model_has_roles',
            'password_reset_tokens',
            'personal_access_tokens',
            'plantillas_descargas',
            'role_has_permissions',
            'sessions',
            'telescope_entries',
            'telescope_entries_tags',
            'telescope_monitoring',
            'user_imports',
            'archivos_cargados'
        ]
    ],
    'columns' => [
        'exclude' => [
            'id',
            'created_at',
            'updated_at',
            'deleted_at',
            'email_verified_at',
            'remember_token',
            'user_id'
        ]
    ],
    // Mapeo 'tabla' => 'modelo'
    'models' => [
        'users' => App\Models\User::class,
        'perfiles' => ILC\AdminUsuarios\Models\Perfil::class,
        'roles' => App\Models\Role::class,
        'permissions' => Spatie\Permission\Models\Permission::class,
    ],
    // Mapeo de columnas de tabla a encabezados del listado
    'catalog_fields_mapping' => [
        // 'campo_tabla' => 'encabezado'
        'users' => [
            'id' => 'id',
            'name' => 'nombre',
            'email' => 'correo electrónico',
        ],
        'perfiles' => [
            'id' => 'id',
            'nombre' => 'nombre',
            'primer_apellido' => 'primer apellido',
            'segundo_apellido' => 'segundo apellido',
            'curp' => 'curp',
        ],
        'roles' => [
            'id' => 'id',
            'name' => 'nombre',
            'guard_name' => 'guard',
        ],
        'permissions' => [
            'id' => 'id',
            'name' => 'nombre',
            'guard_name' => 'guard',
        ],
    ],
    // campos que serán utilizados para buscar
    'searchable_fields' => [
        'users' => ['name', 'email'],
        'perfiles' => ['nombre', 'primer_apellido', 'segundo_apellido', 'curp'],
        'roles' => ['name', 'guard_name'],
        'permissions' => ['name', 'guard_name'],
    ],
    'validations' => [
        'roles' => [
            'name' => 'required|string|max:255|unique:roles,name',
            'guard_name' => 'required|string|max:255|unique:roles,name',
        ],
        'permissions' => [
            'name' => 'required|string|max:255|unique:roles,name',
            'guard_name' => 'required|string|max:255|unique:roles,name',
        ],
        'users' => [
            'name' => 'required|string|max:255|unique:users,name',
            'email' => 'required|string|email|max:255|unique:users,email',
            'password' => 'required|string|min:6',
        ]
    ]
];
