# Paquete de Gestión de Archivos y CRUDs Dinámicos

Este paquete permite gestionar cargas de archivos desde CSV o Excel, definir y exportar plantillas en Excel, y generar CRUDs dinámicos para catálogos.

## Cargas de Archivo
Las definiciones de carga permiten:
- Mapear las columnas de una plantilla Excel con los campos de una tabla.
- Definir los tipos de datos.
- Almacenar la configuración para su uso posterior.

Una vez guardada la definición, se puede utilizar para validar e importar datos en la tabla de destino.

## Exportación de Datos
Permite:
- Seleccionar los datos a exportar desde una tabla (o tablas relacionadas).
- Guardar la configuración de la exportación.
- Generar una plantilla Excel con los campos y datos definidos.

## Generación de CRUDs
El paquete permite crear CRUDs dinámicos para catálogos simples (sin relaciones con otras tablas por el momento), utilizando **JSON Schema Forms**.

## Instalación

Puede instalarse el paquete con los siguientes comandos:

```bash
composer require improving-labor-courts/cargaarchivos

php artisan cargaarchivos:install

```
## Migrations
Al ejecutar el comando de instalación del paquete, se ejecutarán dos migraciones que crearán dos tablas, 
junto con un seeder que añadirá los permisos básicos del paquete al catálogo de permisos.

```php
// Tabla que almacenará la definición de las cargas de archivo
archivos_cargados
// Tabla que almacenará las plantillas de descarga
plantillas_descargas
```
## Archivos de configuración
Adicionalmente, el paquete también un archivo de configuración en el paquete padre con el siguiente contenido como base:

```php
return [
    // Tablas excluidas
    'tables' => [
        'exclude' => [
            'audits',
            'cache',
            'cache_locks',
            'failed_jobs',
            'job_batches',
            'jobs',
            'migrations',
            'model_has_permissions',
            'model_has_roles',
            'password_reset_tokens',
            'personal_access_tokens',
            'plantillas_descargas',
            'role_has_permissions',
            'sessions',
            'telescope_entries',
            'telescope_entries_tags',
            'telescope_monitoring',
            'user_imports',
            'archivos_cargados'
        ]
    ],
    // Campos excluidos
    'columns' => [
        'exclude' => [
            'id',
            'created_at',
            'updated_at',
            'deleted_at',
            'user_id'
        ]
    ],
    // Mapeo de modelos
    'models' => [
        'users' => App\Models\User::class,
        'perfiles' => ILC\AdminUsuarios\Models\Perfil::class,
        'roles' => App\Models\Role::class,
        'permissions' => Spatie\Permission\Models\Permission::class,
    ],
    // Mapeo de campos de catálogos
    'catalog_fields_mapping' => [
        'users' => [
            'id' => 'Id',
            'name' => 'Nombre',
            'email' => 'Correo Electrónico',
            'updated_at' => 'Última Actualización'
        ],
        'perfiles' => [
            'id' => 'Id',
            'nombre' => 'Nombre',
            'primer_apellido' => 'Primer Apellido',
            'segundo_apellido' => 'Segundo Apellido',
            'curp' => 'CURP',
        ],
        'roles' => [
            'id' => 'id',
            'name' => 'nombre',
            'guard_name' => 'guard',
            'updated_at' => 'última actualización'
        ],
        'permissions' => [
            'id' => 'id',
            'name' => 'nombre',
            'guard_name' => 'guard',
            'updated_at' => 'última actualización'
        ],
    ],
    // Campos para búsqueda
    'searchable_fields' => [
        'users' => ['name', 'email'],
        'perfiles' => ['nombre', 'primer_apellido', 'segundo_apellido', 'curp'],
        'roles' => ['name', 'guard_name'],
        'permissions' => ['name', 'guard_name'],
    ],
    // Validaciones
    'validations' => [
        'roles' => [
            'name' => 'required|string|max:255|unique:roles,name',
            'guard_name' => 'required|string|max:255|unique:roles,name',
        ],
        'permissions' => [
            'name' => 'required|string|max:255|unique:roles,name',
            'guard_name' => 'required|string|max:255|unique:roles,name',
        ],
    ],
    'import' => [
        'max_execution_time' => env('IMPORT_MAX_EXECUTION_TIME', 300),
        'memory_limit' => env('IMPORT_MEMORY_LIMIT', '512M'),
        'max_input_time' => env('IMPORT_MAX_INPUT_TIME', 300),
        'max_upload_size' => env('IMPORT_MAX_FILE_SIZE', '100M'),
        'post_max_size' => env('IMPORT_POST_MAX_SIZE', '100M'),
    ],
];
```
### Tablas Excluidas
Lista de tablas que no se utilizarán para la generación de formularios dinámicos.  
Cualquier tabla que no esté en esta lista estará disponible para la generación de formularios.

### Campos Excluidos
Registro de los campos que no deben incluirse en los CRUDs de los formularios dinámicos.  
Estos campos se excluyen de forma global, por lo que no es necesario especificar la tabla.

### Mapeo de Modelos
Asociación entre el nombre de la tabla y el namespace del modelo correspondiente.  
El modelo puede pertenecer a otro paquete, siempre que se defina correctamente su namespace.

### Mapeo de Campos de Catálogos
Definición de los campos a incluir por tabla y el título que se mostrará en los listados de los catálogos dinámicos.

### Campos para Búsqueda
Especificación de los campos por tabla que podrán utilizarse para realizar búsquedas en los listados de los catálogos dinámicos.

### Validaciones
Definición de los campos de cada tabla y las reglas de validación que se aplicarán a cada uno.

### Middleware
Este paquete incluye un middleware `import.limits` que establece límites de PHP más altos para operaciones de importación:

- `max_execution_time`: 30 minutos
- `memory_limit`: 512MB
- `max_input_time`: 30 minutos

### Seeder
Para correr el seeder manualmente
```bash
php artisan db:seed --class="ILC\CargaArchivos\Database\Seeders\PermissionsSeeder
```

### Usando el middleware
Puede aplicar el middleware a cualquiera de las rutas que necesiten límites de PHP más altos:

```php
// En los archivos routes/web.php o routes/api.php
Route::post('/ruta-de-ejemplo', [EjemploController::class, 'metodo'])
    ->middleware('import.limits');
```
O se puede aplicar a un grupo de rutas:

```php
Route::middleware(['import.limits'])->group(function () {
    // Rutas con límites mas altos
});
```

### Personalizando el middleware

Si se necesita personalizar la configuración del middleware, se puede publicar la configuración del paquete:

```bash
php artisan vendor:publish --tag="cargaarchivos-config"
```

Luego editar el archivo de configuración publicado para establecer los límites deseados.

### Variables de entorno
También puede personalizar los límites usando variables de entorno en su archivo .env:

```bash
# Tiempo máximo de ejecución en segundos
IMPORT_MAX_EXECUTION_TIME=300
# Límite de memoria para operaciones de importación
IMPORT_MEMORY_LIMIT=512M
# Tiempo máximo para procesar datos de entrada (formularios)
IMPORT_MAX_INPUT_TIME=300
# Tamaño máximo de archivo para subidas
IMPORT_MAX_FILE_SIZE=100M
# Tamaño máximo de datos POST permitidos
IMPORT_POST_MAX_SIZE=100M
```


### Config php.ini
Si se desea importar un archivo mas pesado a 8MB es necesario realizar los siguientes ajustes en php.ini

```bash
# Ubicación del archivo php.ini dentro del servidor en Docker
/etc/php/8.3/fpm/php.ini

post_max_size = 12M
upload_max_filesize = 10M
```

### Config Ngnix carga de datos masiva
De igual manera si el documento a importar pesa mas de 8MB se requiere modificar la configuración de ngnix

```bash
# Ubicación del archivo de configuración dentro del servidor en Docker
/etc/nginx/sites-available/default

server { 
    listen 80; 
    server_name exhortos.dev; 
    root /var/www/html/public; 
    index index.php index.html index.htm;
    
    # Agregar estas línea
    client_max_body_size 20M;    
    fastcgi_read_timeout 1800;
    fastcgi_connect_timeout 1800;
    fastcgi_send_timeout 1800;
    
    location / { 
        try_files $uri $uri/ /index.php?$query_string; 
    } 
    location ~ \.php$ { 
        try_files $uri =404; 
        fastcgi_pass unix:/run/php/php8.3-fpm.sock; 
        fastcgi_index index.php; 
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name; 
        include fastcgi_params; 
    } 
}
```
Para verificar que la configuración sea correcta:

```bash
# verificar configuración
nginx -t
# reiniciar ngnix
service nginx restart
```

### Documentación API (Swagger)
Para generar y publicar la documentación de Swagger, ejecuta los siguientes comandos:

```bash
php artisan vendor:publish --tag="l5-swagger-config"
php artisan vendor:publish --tag="l5-swagger-views"
php artisan l5-swagger:generate


## Credits

- [Fernando Valadez Castillo](https://github.com/ImprovingLaborCourts)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.

