<?php

namespace ILC\CargaArchivos;

use ILC\CargaArchivos\Http\Middleware\SetImportLimits;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Pluralizer;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use ILC\CargaArchivos\Commands\CargaArchivosCommand;
use Illuminate\Routing\Router;
use Spatie\Permission\Middleware\PermissionMiddleware;

class CargaArchivosServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {
        $package
            ->name('cargaarchivos')
            ->hasRoutes('api')
            ->hasConfigFile('l5-swagger')
            ->hasConfigFile('cargaarchivos')
            ->hasViews()
            ->hasTranslations()
            ->hasMigration('create_archivos_cargados_table')
            ->hasMigration('create_plantillas_descargas_table')
            ->hasCommand(CargaArchivosCommand::class)
            ->hasInstallCommand(function (InstallCommand $command) {
                $command
                    ->startWith(function (InstallCommand $command) {
                        $command->info('Instalación del paquete ILC\CargaArchivos');
                    })
                    ->publishConfigFile()
                    ->publishMigrations()
                    ->askToRunMigrations()
                    ->endWith(function (InstallCommand $command) {
                        $command->info('corriendo seeders...');
                        Artisan::call(
                            'db:seed',
                            ['--class' => 'ILC\\CargaArchivos\\Database\\Seeders\\PermissionsSeeder']
                        );
                        $command->info(Artisan::output());
                        App::currentLocale('es');
                        Pluralizer::useLanguage('spanish');
                        $command->info('Paquete instalado!');
                    });
            });
    }

    public function packageRegistered()
    {
        $router = $this->app->make(Router::class);
        $router->aliasMiddleware('import.limits', SetImportLimits::class);
    }
}
