<?php

namespace ILC\CargaArchivos\Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionsSeeder extends Seeder
{
    /**
     * @return void
     */
    public function run(): void
    {
        $guards = ['web'];

        // Nombre correspondiente a los permisos de edición por cada funcionalidad
        // del paquete (se vuelve a usar más abajo para los menús).
        $edicion_carga = 'editar-definiciones-carga';
        $edicion_exportacion = 'editar-definiciones-exportacion';
        $edicion_catalogos = 'editar-catalogos-dinamicos';

        // Módulos en común,
        $modulo_carga = '[CargaArchivos] Importación';
        $modulo_exportacion = '[CargaArchivos] Exportación';
        $modulo_catalogos = '[CargaArchivos] Catálogos dinámicos';

        $permissions = [
            [
                'visualizar-definiciones-carga',
                'READ de definiciones de archivos de importación.',
                $modulo_carga,
            ],
            [
                'guardar-definiciones-carga',
                'CREATE de definiciones de archivos de importación.',
                $modulo_carga,
            ],
            [
                $edicion_carga,
                'UPDATE de definiciones de archivos de importación.',
                $modulo_carga,
            ],
            [
                'eliminar-definiciones-carga',
                'DELETE de definiciones de archivos de importación.',
                $modulo_carga,
            ],
            [
                'visualizar-definiciones-exportacion',
                'READ de plantillas de exportación.',
                $modulo_exportacion,
            ],
            [
                'guardar-definiciones-exportacion',
                'CREATE de plantillas de exportación.',
                $modulo_exportacion,
            ],
            [
                $edicion_exportacion,
                'UPDATE de plantillas de exportación.',
                $modulo_exportacion,
            ],
            [
                'eliminar-definiciones-exportacion',
                'DELETE de plantillas de exportación.',
                $modulo_exportacion,
            ],
            [
                'visualizar-catalogos-dinamicos',
                'READ de registros de catálogos dinámicos.',
                $modulo_catalogos,
            ],
            [
                'guardar-catalogos-dinamicos',
                'CREATE de registros de catálogos dinámicos.',
                $modulo_catalogos,
            ],
            [
                $edicion_catalogos,
                'UPDATE de registros de catálogos dinámicos.',
                $modulo_catalogos,
            ],
            [
                'eliminar-catalogos-dinamicos',
                'DELETE de registros de catálogos dinámicos.',
                $modulo_catalogos,
            ],
            [
                'exportar-mediante-template',
                'Permite exportar datos al seleccionar alguna plantilla de exportación.',
                $modulo_exportacion,
            ],
        ];

        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        foreach ($guards as $guard_name) {
            foreach ($permissions as $permission) {
                Permission::updateOrCreate([
                    'name' => $permission[0],
                    'guard_name' => $guard_name,
                ], [
                    'description' => $permission[1],
                    'module' => $permission[2],
                ]);
            }
        }

        $role = Role::firstOrCreate(['name' => 'Super usuario']);
        $permissions = Permission::pluck('id','id')->all();
        $role->permissions()->syncWithoutDetaching($permissions);

        if (app()->environment('local')) {

            $user = User::firstOrCreate(
                ['email' => 'admin@teclab.mx'],
                [
                    'name' => 'Super usuario',
                    'password' => 'password'
                ]
            );

            $user->perfil()->firstOrCreate(
                ['curp' => 'XEXX010101HNEXXXA4'],
                [
                    'nombre' => 'Super usuario',
                    'primer_apellido' => 'General',
                    'segundo_apellido' => ''
                ]);

            $user->assignRole([$role->id]);
            $user->givePermissionTo($permissions);
        }

        $menuRootId = DB::table('menu_root')->where('enabled', '=', true)->pluck('id')->first();

        DB::table('menus')->updateOrInsert([
            'name' => 'Exportar datos',
        ], [
            'parent_id' => null,
            'route' => '/admin/data-exporter',
            'icon' => 'mdi-file-export-outline',
            'order' => 9,
            'description' => 'Exportar datos de los catálogos',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => $edicion_carga,
            'icon_name' => 'mdiFileExportOutline',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('menus')->updateOrInsert([
            'name' => 'Cargar datos',
        ], [
            'parent_id' => null,
            'route' => '/admin/data-loader',
            'icon' => 'mdi-file-import-outline',
            'order' => 10,
            'description' => 'Cargar datos desde definiciones de archivos',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => $edicion_exportacion,
            'icon_name' => 'mdiFileExportOutline',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('menus')->updateOrInsert([
            'name' => 'Catálogos dinámicos',
        ], [
            'parent_id' => null,
            'route' => '/admin/catalogs/permissions',
            'icon' => 'mdi-form-select',
            'order' => 11,
            'description' => 'Genera catálogos dinámicamente',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => $edicion_catalogos,
            'icon_name' => 'mdiFormSelect',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

    }
}
