<?php

namespace ILC\CargaArchivos\Providers;

use Illuminate\Support\ServiceProvider;

class SwaggerServiceProvider extends ServiceProvider
{
    public function boot()
    {
        $this->app->register(SwaggerServiceProvider::class);

        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../../config/l5-swagger.php' => $this->app->configPath('l5-swagger.php'),
            ], 'l5-swagger-config');

            $this->publishes([
                __DIR__.'/../../resources/views' => $this->app->resourcePath('views/vendor/l5-swagger'),
            ], 'l5-swagger-views');
        }

        $this->loadRoutesFrom(__DIR__.'/../../routes/api.php');
        $this->loadViewsFrom(__DIR__.'/../../resources/views', 'l5-swagger');
    }

    public function register()
    {
        $this->mergeConfigFrom(
            __DIR__.'/../../config/l5-swagger.php', 'l5-swagger'
        );
    }
}
