<?php

namespace ILC\CargaArchivos\Traits;

use ILC\CargaArchivos\Rules\Curp;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Log;

trait HandlesImportedDataValidation
{
    protected function generateValidationRulesForSheet(array $sheetStructure): array
    {
        $rules = [];

        foreach ($sheetStructure['columnas'] as $column) {

            $columnName = $column['nombre'];
            $rules[$columnName] = $this->getValidationRulesForColumn($column);
        }

        return $rules;
    }


    protected function getValidationRulesForColumn(array $column): array
    {
        $ruleSet = [];
        $ruleSet[] = $column['requerido'] ? 'required' : 'nullable';
        $ruleSet[] = match ($column['tipo']) {
            'numérico' => 'integer',
            'verdadero/falso' => 'boolean',
            'fecha' => 'date',
            'curp' => new Curp(),
            default => 'string',
        };

        return $ruleSet;
    }


    public function validateMappedData(array $mappedData, array $rules, array $messages): void
    {
        $validator = Validator::make($mappedData, $rules, $messages);

        try {
            $validator->validate();
        } catch (ValidationException $e) {
            throw new ValidationException($validator);
        }
    }


    /**
     * @return array
     */
    public function validationMessages(): array
    {
        return [
            'alpha'                 => 'El campo :attribute sólo puede contener letras.',
            'boolean'               => 'El campo :attribute debe ser verdadero o falso.',
            'date'                  => 'El campo :attribute no es una fecha válida.',
            'date_format' 	        => 'El campo :attribute no corresponde con el formato :format.',
            'email'                 => 'El formato del :attribute no es válido.',
            'exists'                => 'El campo :attribute no existe.',
            'file'                  => 'El campo :attribute debe ser un archivo.',
            'filled'                => 'El campo :attribute es requerido.',
            'in'                    => 'El campo :attribute seleccionado no es válido.',
            'integer'               => 'El campo :attribute debe ser un entero.',
            'required'              => 'El campo :attribute es requerido.',
            'string'                => 'El campo :attribute debe ser una cadena.',
            'unique'                => 'El campo :attribute ya se encuentra registrado.',
            'uploaded'              => 'El campo :attribute no ha podido ser cargado.',
            'curp_rule'             => ['required', new Curp],
        ];
    }

}
