<?php

namespace ILC\CargaArchivos\Traits;

use ILC\CargaArchivos\Models\ILCPlantillaDescarga;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

trait CatalogsQueryTrait {

    public function validateCatalogWithConfigOptions(string $table): array
    {
        $excludedTables = config('cargaarchivos.tables.exclude', []);
        if (in_array($table, $excludedTables)) {
            return [
                'error'  => 'La tabla elegida no es un catálogo válido.',
                'status' => 400
            ];
        }

        $modelsMapFromConfig = config('cargaarchivos.models', []);
        if (!array_key_exists($table, $modelsMapFromConfig)) {
            return [
                'error'  => 'No se encontró una relación entre la tabla y el modelo en al archivo de configuración.',
                'status' => 400
            ];
        }

        $modelClass = $modelsMapFromConfig[$table] ?? null;

        if ($modelClass && !class_exists($modelClass)) {
            return [
                'error'  => 'No se encontró el modelo especificado.',
                'status' => 500
            ];
        }

        $allColumnsFromTable = Schema::getColumnListing($table);
        $selectableColumnsFromConfig = config('cargaarchivos.catalog_fields_mapping.'.$table, []);
        $filteredColumns = array_intersect($allColumnsFromTable, array_keys($selectableColumnsFromConfig));

        return [
            'modelClass'        => $modelClass,
            'filteredColumns' => $filteredColumns,
        ];
    }
    public function applySorting($query, Request $request): void
    {
        $model = $query->getModel();
        $table = $model->getTable();
        $sortFields = $request->input('filter.sort');

        if ($request->filled('filter.sort')) {
            foreach (explode(',', $sortFields) as $sortField) {
                $direction = Str::startsWith($sortField, '-') ? 'desc' : 'asc';
                $field = ltrim($sortField, '-');

                $query->orderBy($field, $direction);
            }
        } else {
            $defaultOrder = $request->get('order', "{$table}.{$model->getKeyName()}, desc");
            $order = Str::of($defaultOrder)->split('/[\s,|]+/');
            $query->orderBy($order->first(), $order->last());
        }
    }
}
