<?php

namespace ILC\CargaArchivos\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DynamicCatalogRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $table = $this->route('table');
        $rules = config("cargaarchivos.validations.{$table}", []);

        if ($this->isMethod('put')) {
            $id = $this->route('id');

            foreach ($rules as $field => $ruleSet) {
                if (is_string($ruleSet)) {
                    $individualRules = explode('|', $ruleSet);

                    foreach ($individualRules as $index => $rule) {
                        if (strpos($rule, 'unique:') === 0) {
                            $parts = explode(':', $rule, 2);
                            $uniqueParts = explode(',', $parts[1]);

                            if (count($uniqueParts) >= 1) {
                                $uniqueTable = $uniqueParts[0];
                                $uniqueColumn = $uniqueParts[1] ?? $field;
                                $individualRules[$index] = "unique:{$uniqueTable},{$uniqueColumn},{$id}";
                            }
                        }
                    }

                    $rules[$field] = implode('|', $individualRules);

                    if ($field === 'password' && strpos($rules[$field], 'required') !== false) {
                        $rules[$field] = str_replace('required', 'sometimes', $rules[$field]);
                    }
                }
            }
        }

        return $rules;
    }

    public function messages()
    {
        return [
            'required' => 'El campo :attribute es obligatorio.',
            'string'   => 'El campo :attribute debe ser una cadena de caracteres.',
            'max'      => 'El campo :attribute no debe exceder de :max caracteres.',
            'min'      => 'El campo :attribute debe tener al menos :min caracteres.',
            'unique'   => 'El valor del campo :attribute ya ha sido registrado.',
            'integer'  => 'Validación de prueba para un entero'
        ];
    }
}
