<?php

use ILC\CargaArchivos\Http\Controllers\JsonSchemaFormController;
use Illuminate\Support\Facades\Route;
use ILC\CargaArchivos\Http\Controllers\DataLoaderController;
use ILC\CargaArchivos\Http\Controllers\DataExporterController;
use ILC\CargaArchivos\Http\Controllers\CatalogController;
use L5Swagger\Http\Controllers\SwaggerController;
Route::prefix('api/')->middleware(['auth:sanctum','web','api'])->group(function () {

    // Importar
    Route::middleware(['import.limits'])->group(function () {
        Route::post('data-loader/process', [DataLoaderController::class, 'process']);
        Route::post('data-loader/import', [DataLoaderController::class, 'import']);
        Route::post('data-loader/save', [DataLoaderController::class, 'save']);
    });

    Route::get('data-loader', [DataLoaderController::class, 'index']);
    Route::get('data-loader/{id}', [DataLoaderController::class, 'show']);
    Route::get('data-loader/related-tables/{table}', [DataLoaderController::class, 'getRelatedData']);
    Route::put('data-loader/{id}', [DataLoaderController::class, 'update']);
    Route::delete('data-loader/{id}', [DataLoaderController::class, 'destroy']);

    // Exportar
    Route::get('data-exporter', [DataExporterController::class, 'index']);
    Route::get('data-exporter/{table}/fields', [DataExporterController::class, 'getTableFieldsWithRelationships']);
    Route::get('data-exporter/tables', [DataExporterController::class, 'getTablesInDatabase']);
    Route::get('data-exporter/template', [DataExporterController::class, 'exportToExcel']);
    Route::get('data-exporter/{id}', [DataExporterController::class, 'show']);
    Route::post('data-exporter/save', [DataExporterController::class, 'save']);
    Route::put('data-exporter/{id}', [DataExporterController::class, 'update']);
    Route::delete('data-exporter/{id}', [DataExporterController::class, 'destroy']);

    // Formularios dinámicos
    Route::get('/schema/{table}/fields', [JsonSchemaFormController::class, 'getFieldsForSchema']);
    Route::post('/schema/generate', [JsonSchemaFormController::class, 'generateSchema']);
    Route::post('/catalogs/{table}', [CatalogController::class, 'store']);
    Route::get('/catalogs/{table}', [CatalogController::class, 'index']);
    Route::get('/catalogs/{table}/headings', [CatalogController::class, 'getTableHeaders']);
    Route::get('/catalogs/{table}/{id}', [CatalogController::class, 'show']);
    Route::put('/catalogs/{table}/{id}', [CatalogController::class, 'update']);
    Route::delete('/catalogs/{table}/{id}', [CatalogController::class, 'destroy']);
});

// Documentación Swagger
Route::group(['middleware' => 'web'], function () {
    Route::get('api/documentation', [SwaggerController::class, 'api'])
        ->defaults('documentation', 'default')
        ->defaults('config', config('l5-swagger.documentations.default'))
        ->name('l5-swagger.api');

    Route::get('docs', [SwaggerController::class, 'view'])
        ->defaults('documentation', 'default')
        ->defaults('config', config('l5-swagger.documentations.default'))
        ->name('l5-swagger.docs');

    Route::get('oauth2-callback', [SwaggerController::class, 'oauth2Callback'])
        ->name('l5-swagger.oauth2_callback');
});
