<?php

namespace ILC\CargaArchivos\Traits;

use Illuminate\Support\Facades\Cache;

trait ProgressTrackable
{
    protected function initializeUploadProgress(int $totalFiles): string
    {
        $cacheKey = $this->getCacheKey();
        Cache::put($cacheKey, [
            'total_records' => $totalFiles,
            'processed_records' => 0,
            'successful_registrations' => 0,
            'failed_registrations' => 0,
            'progress_percentage' => 0,
        ]);

        return $cacheKey;
    }

    protected function updateUploadProgress(int $successfulRegistrations, int $failedRegistrations, int $processedFiles): void
    {
        $cacheKey = $this->getCacheKey();
        $progress = Cache::get($cacheKey);

        if(!$progress) {
            $this->initializeUploadProgress($successfulRegistrations);
            $progress = Cache::get($cacheKey);

        }

            $progress['total_records'] = $processedFiles;
            $progress['processed_records'] = $processedFiles;
            $progress['successful_registrations'] = $successfulRegistrations;
            $progress['failed_registrations'] = $failedRegistrations;
            $progress['progress_percentage'] = ($progress['total_records'] > 0) ? ($processedFiles / $successfulRegistrations) * 100 : 0;

            Cache::put($cacheKey, $progress);
    }

    protected function getUploadProgress()
    {
        return Cache::get($this->getCacheKey(), [
            'total_records' => 0,
            'processed_records' => 0,
            'successful_registrations' => 0,
            'failed_registrations' => 0,
            'progress_percentage' => 0,
        ]);
    }

    protected function clearUploadProgress(): void
    {
        Cache::forget($this->getCacheKey());
    }

    protected function getCacheKey(): string
    {
        return 'import_progress_' . 100;
    }
}
