<?php

namespace ILC\CargaArchivos\Exceptions;

use Exception;
use Illuminate\Http\JsonResponse;

class AuthorizationException extends Exception
{
    public function __construct($message = 'Permiso Denegado', $code = 403)
    {
        parent::__construct($message, $code);
    }

    public function render(): JsonResponse
    {
        return response()->json([
            'success' => false,
            'code' => $this->getCode(),
            'result' => array('message' => $this->getMessage()),
        ], $this->getCode());
    }
}
