<?php

namespace ILC\CargaArchivos\Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsSeeder extends Seeder
{
    /**
     * @return void
     */
    public function run(): void
    {
        $guards = ['web'];

        $permissions = [
            'ver-lista-definiciones-carga',
            'guardar-definiciones-carga',
            'eliminar-definiciones-carga',
        ];

        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        foreach ($guards as $guard_name) {
            foreach ($permissions as $permission) {
                Permission::firstOrCreate([
                    'name' => $permission,
                    'guard_name' => $guard_name,
                ]);
            }
        }

    }
}
