<?php
namespace ILC\CargaArchivos\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Foundation\Http\FormRequest as BaseFormRequest;
use ILC\CargaArchivos\Exceptions\AuthorizationException;

class FormRequest extends BaseFormRequest
{
    /**
     * @param Validator $validator
     * @return void
     */
    protected function failedValidation(Validator $validator): void
    {
        throw new HttpResponseException(
            response()->json([
                    'success' => false,
                    'code' => 422,
                    'result' => array('message' =>  $this->validator->errors()->first())
                ]
            ));
    }

    /**
     * @throws AuthorizationException
     */
    protected function failedAuthorization()
    {
        throw new AuthorizationException();
    }
}
