<?php
namespace ILC\CargaArchivos\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FileDefinitionRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'nombre' => 'required|string',
            'referencia_nombre' => 'required|string|unique:archivos_cargados,referencia_nombre',
            'descripcion' => 'nullable|string',
            'mapa_estructura' => 'required|array',
            'mapa_estructura.hojas.*.columnas.*.nombre' => 'nullable|string',
            'mapa_modelo' => 'required|array',
            'mapa_modelo.hoja' => 'required|string',
            'mapa_modelo.tabla' => 'required|string',
            'mapa_modelo.columnas' => 'required|array',
            'mapa_modelo.columnas.*.columna_archivo' => 'required|integer',
            'mapa_modelo.columnas.*.columna_bd' => 'required|string',
            'tipo_archivo' => 'required|string',
        ];
    }

}
