<?php

namespace ILC\CargaArchivos\Http\Controllers;

use ILC\CargaArchivos\Events\FileDefinitionSaved;
use ILC\CargaArchivos\Http\Requests\DataLoaderRequest;
use ILC\CargaArchivos\Http\Requests\FileDefinitionRequest;
use ILC\CargaArchivos\Http\Resources\DataDefinitionResource;
use ILC\CargaArchivos\Models\ILCCargaArchivo;
use ILC\CargaArchivos\Services\CargaArchivos;
use Illuminate\Support\Facades\Log;

class DataLoaderController extends Controller
{
    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $perPage = 10;
        $fileDefinitions = ILCCargaArchivo::paginate($perPage);
        $data = DataDefinitionResource::collection($fileDefinitions)
            ->response()
            ->getData(true);

        return $this->sendResponse($data);
    }


    /**
     * @param DataLoaderRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function process(DataLoaderRequest $request)
    {
        $file = $request->file('archivo');
        $processedDefinition = CargaArchivos::archivo(null, $file)->getJson();

        if ($processedDefinition ) {
            return $this->sendResponse([ 'data' =>  $processedDefinition ]);
        }

        return $this->sendError('No se pudo procesar el archivo.');
    }


    /**
     * @param DataLoaderRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function save(FileDefinitionRequest $request)
    {
        $validatedData = $request->validated();
        $fileDefinition = new ILCCargaArchivo();
        $fileDefinition->nombre = $validatedData['nombre'];
        $fileDefinition->referencia_nombre = $validatedData['referencia_nombre'];
        $fileDefinition->descripcion = $validatedData['descripcion'] ?? null;
        $fileDefinition->mapa_estructura = json_encode($validatedData['mapa_estructura']);
        $fileDefinition->mapa_modelo = json_encode($validatedData['mapa_modelo']);

        $fileDefinition->tipo_archivo = $validatedData['tipo_archivo'];

        if ($fileDefinition->save()) {
            event(new FileDefinitionSaved($fileDefinition));

            return $this->sendResponse(['message' => 'Definición de archivo guardada exitosamente.']);
        }

        return $this->sendError('No se pudo guardar el archivo.');
    }


    /**
     * @param int $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(int $id)
    {
        $fileDefinition = ILCCargaArchivo::find($id);

        if (!$fileDefinition) {
            return $this->sendError('No se encontró la definición del archivo.');
        }

        try {
            $fileDefinition->delete();

            return $this->sendResponse('La definición del archivo se ha eliminado exitosamente.');
        } catch (\Exception $e) {
            Log::error('Error al eliminar definición de archivo: '.$e->getMessage());

            return $this->sendError('Ha ocurrido un error al intentar eliminar la definición del archivo.');
        }

    }
}
