<?php

namespace ILC\CargaArchivos;

use Illuminate\Support\Facades\Artisan;
use Spatie\LaravelPackageTools\Commands\InstallCommand;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;
use ILC\CargaArchivos\Commands\CargaArchivosCommand;

class CargaArchivosServiceProvider extends PackageServiceProvider
{
    public function configurePackage(Package $package): void
    {

        $package
            ->name('cargaarchivos')
            ->hasRoutes('api')
            ->hasConfigFile()
            ->hasViews()
            ->hasMigration('create_archivos_cargados_table')
            ->hasCommand(CargaArchivosCommand::class)
            ->hasInstallCommand(function (InstallCommand $command) {
               $command
                   ->startWith(function(InstallCommand $command) {
                       $command->info('Instalación del paquete ILC\CargaArchivos');
                   })
                   ->publishMigrations()
                   ->askToRunMigrations()
                   ->endWith(function(InstallCommand $command) {
                       $command->info('corriendo seeders...');
                       Artisan::call('db:seed', ['--class' => 'ILC\\CargaArchivos\\Database\\Seeders\\PermissionsSeeder']);
                       $command->info(Artisan::output());
                       $command->info('Paquetes instalado!');
                   });
            });
    }
}
