<?php

namespace ILC\CargaArchivos\Traits;

use ILC\CargaArchivos\Models\ILCCargaArchivo;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

trait DataLoaderQueryTrait {
    public function buildDataLoaderQuery(Request $request)
    {
        return ILCCargaArchivo::query()->select(
            'archivos_cargados.id',
            'archivos_cargados.nombre',
            'archivos_cargados.referencia_nombre',
            'archivos_cargados.no_fila_encabezados',
            'archivos_cargados.descripcion',
            'archivos_cargados.tipo_archivo',
            DB::raw("TO_CHAR(archivos_cargados.created_at, 'YYYY-MM-DD') as fecha_creacion")
        )->groupBy(
            'archivos_cargados.id',
            'archivos_cargados.nombre',
            'archivos_cargados.referencia_nombre',
            'archivos_cargados.no_fila_encabezados',
            'archivos_cargados.descripcion',
            'archivos_cargados.tipo_archivo',
            'archivos_cargados.created_at',
            );
    }

    public function applySorting($query, Request $request): void
    {
        $sortFields = $request->input('filter.sort');

        if ($request->filled('filter.sort')) {
            foreach (explode(',', $sortFields) as $sortField) {
                $direction = Str::startsWith($sortField, '-') ? 'desc' : 'asc';
                $field = ltrim($sortField, '-');

                $query->orderBy($field, $direction);
            }
        } else {
            $order = Str::of($request->get('order', 'archivos_cargados.id, desc'))->split('/[\s,|]+/');
            $query->orderBy($order->first(), $order->last());
        }
    }
}
