<?php

namespace ILC\CargaArchivos\Traits;

trait HandlesImportDetails
{
    protected function initializeImportDetails(string $fileName): array
    {
        return [
            'file_name' => $fileName,
            'total_records_in_file' => 1,
            'records_added' => 0,
            'records_updated' => 0,
            'records_with_errors' => 0,
            'errors_detail' => null,
        ];
    }

    protected function addRecordToImportDetails(array &$importDetails): void
    {
        $importDetails['records_added']++;
    }

    protected function addErrorToImportDetails(array &$importDetails, string $fileName, string $errorMessage): void
    {
        $importDetails['records_with_errors']++;
        $importDetails['errors_detail'] = json_encode([
            'campo' => $fileName,
            'error' => $errorMessage,
        ]);
    }

    protected function recordFailedRegistrationDetail(array &$failedRegistrationsDetail, string $fileName, string $errorMessage): void
    {
        $failedRegistrationsDetail['errors_detail'][] = [
            'campo' => $fileName,
            'error' => $errorMessage,
        ];
    }
}
