<?php
namespace ILC\CargaArchivos\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Log;

class FileDefinitionRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    protected function prepareForValidation(): void
    {
        $mapaEstructura = $this->input('mapa_estructura');
        $mapaModelo = $this->input('mapa_modelo');

        if (is_string($mapaEstructura)) {
            $mapaEstructura = json_decode($mapaEstructura, true);
        }

        if (is_string($mapaModelo)) {
            $mapaModelo = json_decode($mapaModelo, true);
        }

        if (isset($mapaEstructura['hojas'])) {
            foreach ($mapaEstructura['hojas'] as &$hoja) {
                if (isset($hoja['columnas'])) {
                    foreach ($hoja['columnas'] as &$columna) {
                        $columna['requerido'] = filter_var($columna['requerido'] ?? false, FILTER_VALIDATE_BOOLEAN);
                        $columna['registro_unico'] = filter_var($columna['registro_unico'] ?? false, FILTER_VALIDATE_BOOLEAN);
                    }
                }
            }
        }

        $this->merge([
            'mapa_estructura' => $mapaEstructura,
            'mapa_modelo' => $mapaModelo,
        ]);
    }

    public function rules()
    {
        $id = $this->route('id');

        return [
            'nombre' => 'sometimes|string|max:255',
            'referencia_nombre' => [
                'nullable',
                'string',
                Rule::unique('archivos_cargados', 'referencia_nombre')->ignore($id),
            ],
            'no_fila_encabezados' => 'sometimes|integer',
            'descripcion' => 'nullable|string',

            'mapa_estructura' => 'sometimes|array',
            'mapa_estructura.hojas' => 'sometimes|array',
            'mapa_estructura.hojas.*.nombre' => 'required|string',
            'mapa_estructura.hojas.*.posicion_hoja' => 'required|integer',
            'mapa_estructura.hojas.*.columnas' => 'required|array',
            'mapa_estructura.hojas.*.columnas.*.nombre' => 'required|string',
            'mapa_estructura.hojas.*.columnas.*.posicion' => 'required|integer',
            'mapa_estructura.hojas.*.columnas.*.tipo' => 'required|string',
            'mapa_estructura.hojas.*.columnas.*.requerido' => 'sometimes|boolean',
            'mapa_estructura.hojas.*.columnas.*.registro_unico' => 'sometimes|boolean',

            'mapa_modelo' => 'sometimes|array',
            'mapa_modelo.hojas' => 'sometimes|array',
            'mapa_modelo.hojas.*.nombre' => 'sometimes|string',
            'mapa_modelo.hojas.*.tabla' => 'sometimes|string',
            'mapa_modelo.hojas.*.columnas' => 'sometimes|array',
            'mapa_modelo.hojas.*.columnas.*.columna_archivo' => 'sometimes|integer',
            'mapa_modelo.hojas.*.columnas.*.columna_bd' => 'sometimes|string',
            'tipo_archivo' => Rule::in(['excel', 'csv']),
        ];
    }



    /**
     * @return array
     */
    public function messages(): array
    {
        return [
            'nombre.required' => 'El campo :attribute es requerido.',
            'nombre.string' => 'El campo :attribute debe ser una cadena de texto.',
            'no_fila_encabezados.required' => 'El campo :attribute es requerido.',
            'no_fila_encabezados.integer' => 'El campo :attribute debe ser un número',
            'referencia_nombre.required' =>  'El campo :attribute es requerido.',
            'referencia_nombre.string' => 'El campo :attribute debe ser una cadena de texto.',
            'referencia_nombre.unique' => 'El campo :attribute debe contener un valor único.',
            'descripcion.string' => 'El campo :attribute debe ser una cadena de texto.',
            'mapa_estructura.required' => 'El campo :attribute es requerido.',
            'mapa_estructura.array' => 'El campo :attribute debe ser un arreglo.',
            'mapa_estructura.hojas.*.columnas.*.nombre.required' => 'El campo :attribute es requerido.',
            'mapa_estructura.hojas.*.columnas.*.nombre.string' => 'El campo :attribute debe ser una cadena de texto.',
            'mapa_estructura.hojas.*.columnas.*.posicion.required' => 'El campo :attribute es requerido.',
            'mapa_estructura.hojas.*.columnas.*.posicion.integer' => 'El campo :attribute debe ser un número.',
            'mapa_estructura.hojas.*.columnas.*.tipo.required' => 'El campo :attribute es requerido.',
            'mapa_estructura.hojas.*.columnas.*.tipo.integer' => 'El campo :attribute debe ser un número.',
            'mapa_estructura.hojas.*.columnas.*.requerido.required' => 'El campo :attribute es requerido.',
            'mapa_estructura.hojas.*.columnas.*.requerido.boolean' => 'El campo :attribute debe contener el valor verdadero o falso.',
            'mapa_modelo.required' => 'El campo :attribute es requerido.',
            'mapa_modelo.array' => 'El campo :attribute debe ser un arreglo.',
            'mapa_modelo.hojas.string' => 'El campo :attribute debe ser una cadena de texto.',
            'mapa_modelo.hojas.required' => 'El campo :attribute es requerido.',
            'mapa_modelo.tabla.required' => 'El campo :attribute es requerido.',
            'mapa_modelo.tabla.string' => 'El campo :attribute debe ser una cadena de texto.',
            'mapa_modelo.columnas.required' => 'El campo :attribute es requerido.',
            'mapa_modelo.columnas.array' => 'El campo :attribute es requerido.',
            'mapa_modelo.columnas.*.columna_archivo.required' => 'El campo :attribute es requerido.',
            'mapa_modelo.columnas.*.columna_bd.required' => 'El campo :attribute es requerido.',
            'mapa_modelo.columnas.*.columna_bd.string' => 'El campo :attribute debe ser una cadena de texto.',
            'tipo_archivo.in' => 'El campo :attribute seleccionado no es válido.',
        ];
    }

    /**
     * @return array
     */
    public function attributes(): array
    {
        return [
            'nombre' => 'nombre',
            'referencia_nombre' => 'nombre de referencia',
            'no_fila_encabezados' => 'número de fila de los encabezados',
            'descripcion' => 'descripción',
            'mapa_estructura' => 'mapeo de la estructura',
            'mapa_modelo' => 'mapeo del modelo',
            'mapa_modelo.hoja' => 'hoja',
            'mapa_modelo.tabla' => 'tabla',
            'mapa_modelo.columnas' => 'columnas',
            'mapa_modelo.columnas.*.columna_archivo' => 'el nombre de la columna en el archivo de la fila :index',
            'mapa_modelo.columnas.*.columna_bd' => 'el nombre de la columna en la base de datos de la fila :index',
            'tipo_archivo' => 'tipo de acción masiva',
        ];
    }

}
