<?php

namespace ILC\CargaArchivos\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class SetImportLimits
{
    /**
     * Ajusta temporalmente la config. de PHP
     * para soportar la importación de archivos con muchos datos
     *
     * @param Request $request
     * @param Closure $next
     * @return Response
     */
    public function handle(Request $request, Closure $next): Response
    {
        $maxExecutionTime = Config::get('cargaarchivos.import.max_execution_time', 300);
        $memoryLimit = Config::get('cargaarchivos.import.memory_limit', '512M');
        $maxInputTime = Config::get('cargaarchivos.import.max_input_time', 300);
        $uploadMaxFilesize = Config::get('cargaarchivos.import.max_input_time', '100M');
        $postMaxSize = Config::get('cargaarchivos.import.post_max_size', '100M');

        ini_set('max_execution_time', $maxExecutionTime);
        ini_set('memory_limit', $memoryLimit);
        ini_set('max_input_time', $maxInputTime);
        ini_set('upload_max_filesize', $uploadMaxFilesize);
        ini_set('post_max_size', $postMaxSize);

        return $next($request);
    }
}
