<?php

namespace ILC\CargaArchivos\Traits;

use ILC\CargaArchivos\Models\ILCPlantillaDescarga;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

trait DataExporterQueryTrait
{
    public function buildDataExporterQuery(Request $request, bool $incluirMapaModelo = false)
    {
        // Columnas que se seleccionarán para el query.
        $columns = [
            'plantillas_descargas.id',
            'plantillas_descargas.nombre',
            'plantillas_descargas.referencia_nombre',
            'plantillas_descargas.descripcion',
            DB::raw("TO_CHAR(plantillas_descargas.created_at, 'YYYY-MM-DD') as fecha_creacion")
        ];
        if ($incluirMapaModelo) {
            array_push($columns, 'plantillas_descargas.mapa_modelo');
        }

        return ILCPlantillaDescarga::query()->select($columns)->groupBy(
            'plantillas_descargas.id',
            'plantillas_descargas.nombre',
            'plantillas_descargas.referencia_nombre',
            'plantillas_descargas.descripcion',
            'plantillas_descargas.created_at',
        );
    }

    // @todo Refactor a un trait de sorting
    public function applySorting($query, Request $request): void
    {
        $sortFields = $request->input('filter.sort');

        if ($request->filled('filter.sort')) {
            foreach (explode(',', $sortFields) as $sortField) {
                $direction = Str::startsWith($sortField, '-') ? 'desc' : 'asc';
                $field = ltrim($sortField, '-');

                $query->orderBy($field, $direction);
            }
        } else {
            $order = Str::of($request->get('order', 'plantillas_descargas.id, desc'))->split('/[\s,|]+/');
            $query->orderBy($order->first(), $order->last());
        }
    }

}
