<?php

namespace ILC\CargaArchivos\Filters;

use PhpOffice\PhpSpreadsheet\Reader\IReadFilter;

class ReadExcelHeadingsFilter implements IReadFilter
{
    private int $maxRow;

    public function __construct(int $maxRow)
    {
        $this->maxRow = $maxRow;
    }

    public function readCell($column, $row, $worksheetName = ''): bool
    {
        // Solo lee hasta el máximo de filas específicado
        return $row <= $this->maxRow;
    }
}
