<?php

namespace ILC\CargaArchivos\Services;

use Illuminate\Support\Facades\Log;

class SchemaService
{
    public function create(array $context): string
    {
        $properties = [];
        Log::debug($context);
        foreach ($context as $type => $meta) {
            $properties[$type] = $this->getField($meta);
        }

        $schemaJson = [
            'type' => 'object',
            'properties' => (object)$properties
        ];

        return json_encode($schemaJson);
    }

    protected function getField(array $meta): array
    {
        $field = [
            'type' => $meta['type'] ?? 'string',
            'title' => $meta['title'] ?? 'Untitled',
            '$id' => $meta['$id'] ?? null,
        ];

        if (isset($meta['description'])) {
            $field['description'] = $meta['description'];
        }

        foreach ($meta as $key => $value) {
            if (!in_array($key, ['type', 'title', '$id', 'description'], true)) {
                $field[$key] = $value;
            }
        }

        return $field;
    }

}
