<?php

namespace ILC\CargaArchivos\Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionsSeeder extends Seeder
{
    /**
     * @return void
     */
    public function run(): void
    {
        $guards = ['web'];

        // Nombre correspondiente a los permisos de edición por cada funcionalidad
        // del paquete (se vuelve a usar más abajo para los menús).
        $edicion_carga = 'editar-definiciones-carga';
        $edicion_exportacion = 'editar-definiciones-exportacion';
        $edicion_catalogos = 'editar-catalogos-dinamicos';

        $permissions = [
            'visualizar-definiciones-carga',
            'guardar-definiciones-carga',
            $edicion_carga,
            'eliminar-definiciones-carga',
            'visualizar-definiciones-exportacion',
            'guardar-definiciones-exportacion',
            $edicion_exportacion,
            'eliminar-definiciones-exportacion',
            'visualizar-catalogos-dinamicos',
            'guardar-catalogos-dinamicos',
            $edicion_catalogos,
            'eliminar-catalogos-dinamicos',
            'exportar-mediante-template',
        ];

        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        foreach ($guards as $guard_name) {
            foreach ($permissions as $permission) {
                Permission::firstOrCreate([
                    'name' => $permission,
                    'guard_name' => $guard_name,
                ]);
            }
        }

        $role = Role::firstOrCreate(['name' => 'Super usuario']);
        $permissions = Permission::pluck('id','id')->all();
        $role->permissions()->syncWithoutDetaching($permissions);

        if (app()->environment('local')) {

            $user = User::firstOrCreate(
                ['email' => 'admin@teclab.mx'],
                [
                    'name' => 'Super usuario',
                    'password' => 'password'
                ]
            );

            $user->perfil()->firstOrCreate(
                ['curp' => 'XEXX010101HNEXXXA4'],
                [
                    'nombre' => 'Super usuario',
                    'primer_apellido' => 'General',
                    'segundo_apellido' => ''
                ]);

            $user->assignRole([$role->id]);
            $user->givePermissionTo($permissions);
        }

        $menuRootId = DB::table('menu_root')->where('enabled', '=', true)->pluck('id')->first();

        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Exportar datos',
            'route' => '/admin/data-exporter',
            'icon' => 'mdi-file-export-outline',
            'order' => 9,
            'description' => 'Exportar datos de los catálogos',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => $edicion_carga,
            'icon_name' => 'mdiFileExportOutline',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Cargar datos',
            'route' => '/admin/data-loader',
            'icon' => 'mdi-file-import-outline',
            'order' => 10,
            'description' => 'Cargar datos desde definiciones de archivos',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => $edicion_exportacion,
            'icon_name' => 'mdiFileExportOutline',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);
        DB::table('menus')->insert([
            'parent_id' => null,
            'name' => 'Catálogos dinámicos',
            'route' => '/admin/catalogs/permissions',
            'icon' => 'mdi-form-select',
            'order' => 11,
            'description' => 'Genera catálogos dinámicamente',
            'separator' => false,
            'layout' => 'left',
            'enabled' => true,
            'permission_name' => $edicion_catalogos,
            'icon_name' => 'mdiFormSelect',
            'menu_root_id' => $menuRootId,
            'created_at' => now(),
            'updated_at' => now(),
        ]);

    }
}
