<?php

namespace ILC\CargaArchivos\Events;

use ILC\CargaArchivos\Models\ILCCargaArchivo;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class FileDefinitionDeleted
{
    use Dispatchable, SerializesModels;

    public ILCCargaArchivo $fileDefinition;

    /**
     * @param ILCCargaArchivo $fileDefinition
     */
    public function __construct(ILCCargaArchivo $fileDefinition) {
        $this->$fileDefinition = $fileDefinition;
        Log::info('Evento FileDefinitionDeleted generado: '.$fileDefinition->referencia_nombre );
    }
}
