<?php

namespace ILC\AdminUsuarios\Http\Controllers;
use ILC\AdminUsuarios\Exports\UsersExport;
use ILC\AdminUsuarios\Exports\UserExportService;
use Illuminate\Http\Request;
use Rap2hpoutre\FastExcel\FastExcel;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class ExportController extends Controller
{

    public function excel(Request $request)
    {
        $usersExport = new UsersExport($request);
        $nameOfFile = $request->query('fileName');
        $timestamp = Carbon::now()->format('YmdHis');
        $fileName = $nameOfFile
            ? preg_replace('/[^a-zA-Z0-9\s._-]/', '', trim($nameOfFile))
            : "ListadoUsuarios_{$timestamp}";

        $fileName = trim($fileName).'.xlsx';

        return response()->streamDownload(function () use ($usersExport) {
            (new FastExcel($usersExport->exportData()))->export('php://output');
        }, $fileName, [
            'Content-Type' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'Content-Disposition' => 'attachment; filename="' . $fileName . '"',
            'Cache-Control' => 'no-cache, no-store, must-revalidate',
            'Pragma' => 'no-cache',
            'Expires' => '0',
        ]);
    }

}
