<?php

namespace ILC\AdminUsuarios\Exceptions;

use Exception;
use Throwable;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Support\Facades\Log;
use Symfony\Component\Console\Application;

class Handler implements ExceptionHandler
{
    public function report(Exception $e)
    {
        Log::info('Error '.$e->getMessage());
    }

    public function shouldReport(Exception $e)
    {
        return true;
    }

    public function render($request, Throwable $e)
    {
        // return view('error.page');
        Log::info('Error Page'.$e->getMessage());
    }

    public function renderForConsole($output, Exception $e)
    {
        Log::info('Error Console'.$e->getMessage());
        (new Application)->renderException($e, $output);
    }
}
