<?php

use Illuminate\Support\Facades\Route;
use ILC\AdminUsuarios\Http\Controllers\AuthController;
use ILC\AdminUsuarios\Http\Controllers\UserController;
use ILC\AdminUsuarios\Http\Controllers\ImportController;
use ILC\AdminUsuarios\Http\Controllers\ExportController;
use ILC\AdminUsuarios\Http\Resources\UserResource;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

Route::post('api/users/reset', [UserController::class, 'reset']);
Route::prefix('api/')->middleware(['ilc.auth','web','api'])->group(function () {
    Route::post('login', [AuthController::class, 'authenticate']);
});

Route::prefix('api/')->middleware(['ilc.auth','auth:sanctum','web','api'])->group(function () {
    Route::put('users/massive', [UserController::class, 'update_massive']);
    Route::post('users/{user}', [UserController::class, 'update']);
    Route::put('users/{user}/status', [UserController::class, 'status']);
    Route::resource('users', UserController::class);
    Route::post('logout', [AuthController::class, 'signout']);

    Route::get('users/imports', [ImportController::class, 'index']);
    Route::get('users/imports/{import}', [ImportController::class, 'show']);

    Route::post('users/imports/certificate', [ImportController::class, 'certificate']);
    Route::post('users/imports/excel', [ImportController::class, 'excel']);
    Route::get('users/export/excel', [ExportController::class, 'excel']);

    Route::get('roles', function (Request $request) {
        return Role::all();
    });

    Route::get('permisos', function (Request $request) {
        return Permission::all();
    });
});
