<?php

namespace ILC\AdminUsuarios\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ImportResource extends JsonResource
{

    protected $context;

    public function __construct($resource, $context = 'index')
    {
        parent::__construct($resource);
        $this->context = $context;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request)
    {
        return [
            'id' => $this->id,
            'archivo' => $this->file_name,
            'no_total_registros' => $this->total_records_in_file,
            'no_registros_nuevos' => $this->records_added,
            'no_registros_actualizados' => $this->records_updated,
            'no_registros_erroneos' => $this->records_with_errors,
            'detail' => $this->when($this->context === 'show', $this->errors_detail),
            'ultima_actualizacion' => $this->updated_at->toDateTimeString(),
        ];
    }
}
