<?php

namespace ILC\AdminUsuarios\Auth;

use ILC\AdminUsuarios\Auth\Contracts\AuthStrategyInterface;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Http\Request;

class AuthManagerContext {

    protected $strategy;

    public function setStrategy(AuthStrategyInterface $strategy): void {
        $this->strategy = $strategy;
    }

    public function getStrategy(): AuthStrategyInterface {
        return $this->strategy;
    }

    public function authenticate(Request $request): ?Authenticatable {
        return $this->strategy->validateCredentials($request);
    }

    public function revoke(): int {
        return $this->strategy->revoke();
    }

}
