<?php

namespace ILC\AdminUsuarios\Traits;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

trait UserQueryTrait {
    public function buildUsersQuery(Request $request)
    {
        return User::select(
            'users.id',
            'users.email',
            'perfiles.estado',
            'perfiles.autenticacion',
            'perfiles.serie',
            'perfiles.nombre',
            'perfiles.primer_apellido',
            'perfiles.segundo_apellido',
            'perfiles.curp',
            'perfiles.genero_id'
        )
            ->leftJoin('perfiles', 'users.id', '=', 'perfiles.user_id')
            ->leftJoin('model_has_roles', 'users.id', '=', 'model_has_roles.model_id')
            ->leftJoin('roles', 'model_has_roles.role_id', '=', 'roles.id')
            ->selectRaw("STRING_AGG(DISTINCT roles.name, ', ' ORDER BY roles.name ASC) as roles")
            ->groupBy(
                'users.id',
                'users.email',
                'perfiles.estado',
                'perfiles.autenticacion',
                'perfiles.serie',
                'perfiles.nombre',
                'perfiles.primer_apellido',
                'perfiles.segundo_apellido',
                'perfiles.curp',
                'perfiles.genero_id'
            );
    }

    public function applySorting($query, Request $request): void
    {
        $sortFields = $request->input('filter.sort');

        if ($request->filled('filter.sort')) {
            foreach (explode(',', $sortFields) as $sortField) {
                $direction = Str::startsWith($sortField, '-') ? 'desc' : 'asc';
                $field = ltrim($sortField, '-');

                if ($field === 'roles') {
                    $query->orderByRaw("STRING_AGG(DISTINCT roles.name, ',') " . $direction);
                } else if (in_array($field, ['nombre', 'primer_apellido', 'segundo_apellido', 'razon_social', 'curp'])) {
                    $query->orderBy("perfiles.$field", $direction);
                } else {
                    $query->orderBy($field, $direction);
                }
            }
        } else {
            $order = Str::of($request->get('order', 'users.id,desc'))->split('/[\s,|]+/');
            $query->orderBy($order->first(), $order->last());
        }
    }
}
