<?php

namespace ILC\AdminUsuarios\Models;

use ILC\AdminUsuarios\Traits\HasPackageFactory;
use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use App\Models\User;

class Perfil extends Model implements Auditable
{
    use HasPackageFactory;
    use \OwenIt\Auditing\Auditable;

    protected $table = 'perfiles';
    protected $fillable = [
        'nombre',
        'primer_apellido',
        'segundo_apellido',
        'genero_id',
        'curp',
        'certificado',
        'serie',
        'estado',
        'autenticacion',
        'user_id'
    ];

    /**
     * Default values for attributes.
     *
     * @var array<int, string>
     */
    protected $attributes = array(
        'estado' => true,
        'autenticacion' => 'default'
    );

    public function user(){
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function genero(){
        return $this->belongsTo(Genero::class);
    }

    /**
     * Get the user's full name.
     *
     * @return string
     */
    public function getNombreCompletoAttribute()
    {
        return trim("{$this->nombre} {$this->primer_apellido} {$this->segundo_apellido}");
    }
}
