<?php

namespace ILC\AdminUsuarios\Http\Controllers;

use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Http\JsonResponse;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Pagination\Paginator;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Validator;

class Controller extends BaseController
{
    /**
     * Retorna el resultado de una petición exitosa.
     *
     * @param $result
     * @param int $code
     * @return JsonResponse
     */
    protected function sendResponse($result = null, int $code = 200): JsonResponse
    {
        $response = array('success' => true, 'code' => $code);
        if (!$result == null){
            if ($result instanceof LengthAwarePaginator ||
                $result instanceof Paginator) {

                $response['result'] = [
                    'data' => $result->items(),
                    'pagination' => [
                        'total' => $result->total(),
                        'count' => $result->count(),
                        'per_page' => $result->perPage(),
                        'current_page' => $result->currentPage(),
                        'total_pages' => $result->lastPage(),
                    ],
                ];
            } else {
                $response['result'] = $result;
            }
        }

        return response()->json($response, $code);
    }


    /**
     * return el error de una petición.
     *
     * @param $error
     * @param int $code
     * @return JsonResponse
     */
    protected function sendError($error, int $code = 404): JsonResponse
    {
        $code = ($code == 0 ? 500 : $code);
    	$response = [
            'success' => false,
            'code' => $code,
            'result' => array('message' => ($code == 401 ? 'Acceso No Autorizado' : $error))
        ];

        if($code == 500){ Log::error('error', $response); }

        return response()->json($response, $code);
    }


    /**
     * Revisa si el usuario está autenticado y tiene permiso de realizar la acción.
     *
     * @param $permission
     * @return bool
     */
    protected function hasPermission($permission): bool
    {
        return auth()->check() && auth()->user()->hasPermissionTo($permission);
    }


}
