<?php

namespace ILC\AdminUsuarios\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class GeneroSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Valores del catálogo
        $valores = [
            'Femenino',
            'Masculino',
            'No binario',
        ];

        foreach ($valores as $valor) {
            // Si ya existe el valor en el catálogo, simplemente saltamos al siguiente registro
            $existe = DB::table('generos')->where('nombre', $valor)->exists();

            if (!$existe) {
                // Si no existe el valor en el catálogo, entonces lo creamos
                DB::table('generos')->insert([
                    'nombre' => $valor,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            } else {
                Log::info("El valor '$valor' ya existe en la tabla 'generos'.");
            }
        }
    }
}
