<?php

namespace ILC\AdminUsuarios\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Attachment;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class UsuarioCreadoMailable extends Mailable
{
    use Queueable, SerializesModels;

    public User $usuario;

    public string $passwordTemporal;

    /**
     * Create a new message instance.
     */
    public function __construct(User $usuario, string $passwordTemporal)
    {
        $this->usuario = $usuario;
        $this->passwordTemporal = $passwordTemporal;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Bienvenido!',
        );
    }

    /**
     * Temporalmente se crea un correo de ejemplo
     *
     * @return Content
     */
    public function content(): Content
    {
        return new Content(view: 'adminusuarios::mail.usuarios.creado',
            with: ['usuario' => $this->usuario,
                'passwordTemporal' => $this->passwordTemporal
            ]
        );
    }

    /**
     * Archivos adjuntos del correo
     *
     * @return array<int, Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
