<?php

namespace ILC\AdminUsuarios\Auth\Strategies;

use ILC\AdminUsuarios\Auth\Contracts\AuthStrategyInterface;
use ILC\AdminUsuarios\Exceptions\InvalidCredentialsException;
use ILC\AdminUsuarios\Exceptions\UserNotFoundException;
use ILC\AdminUsuarios\Http\Requests\ValidateCredentialsRequest;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Support\Facades\Auth;

class ApiAuthStrategy implements AuthStrategyInterface {

    /**
     * @param ValidateCredentialsRequest $request
     * @return ?Authenticatable
     * @throws InvalidCredentialsException
     */
    public function validateCredentials(ValidateCredentialsRequest $request): ?Authenticatable
    {
        $credentials = $request->safe()->only(['email', 'password']);

        if (!Auth::attempt($credentials)) {
            throw new InvalidCredentialsException();
        }

        return Auth::user();
    }


    /**
     * @return int
     * @throws UserNotFoundException
     */
    public function revoke(): int
    {
        $user = Auth::user();

        if (!$user) {
            throw new UserNotFoundException();
        }

        return $user->tokens()->delete();
    }

}
