<?php

namespace ILC\AdminUsuarios\Providers;

use ILC\AdminUsuarios\Listeners\ImportFileUploadEventSubscriber;
use ILC\AdminUsuarios\Listeners\UsuarioEventSubscriber;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{

    public function boot()
    {
        Event::subscribe(UsuarioEventSubscriber::class);
        Event::subscribe(ImportFileUploadEventSubscriber::class);
    }

    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return bool
     */
    public function shouldDiscoverEvents(): bool
    {
        return false;
    }
}
