# Paquete para administrar usuarios e implementar diferentes tipos de autenticación.

Este paquete implementa métodos para administración de usuarios, autenticación de diversos tipos como:
* Correo y contraseña (Default)
* Token
* API

## Installation

Puede instalarse el paquete con el siguiente comando composer

```bash
composer require improving-labor-courts/adminusuarios
```

Una vez descargado el paquete se ejecuta:

```bash
php artisan adminusuarios:install
```
El paquete provee una relación del modelo App\Models\User "hasOne" con el modelo "Perfil" que se asocia de forma automática mediante el método boot del service provider. 
El modelo Perfil tiene el namespace ILC\AdminUsuarios\Models\Perfil

Los métodos y propiedades principales que se proveen son:

```bash        
    $userDatos = [
        'email' => 'test@example.com',
        'password' => 'password123',
    ];

    $perfilDatos = [
        'nombre' => 'CARMEN',
        'primer_apellido' => 'GÓMEZ',
        'segundo_apellido' => 'FICTICIO',
        'curp' => 'GOTC070423HGRMRRA3',
        'autenticacion' => 'default',
        'serie' => '00022233430',
        'certificado' => 'XXXXXXXXXXXXXXXXXXXXXXXXXXXX...',
        'estado' => true,
    ];

    // Creación de usuario con perfil
    try {
        DB::beginTransaction();

        $user = User::create($userDatos);
        $user->perfil()->create($perfilDatos);
        
        DB::commit();
    } 
    catch (\Exception $e) {
        
        DB::rollback();
        
    }
    
    // Actualización de usuario con perfil
    try {
        DB::beginTransaction();

        $user = User::find(123);
        $user->update($userDatos);
        $user->perfil()->update($perfilDatos);
        
        DB::commit();
    } 
    catch (\Exception $e) {
        
        DB::rollback();
        
    }
    
    // Eliminación de usuario con perfil
    try {
        DB::beginTransaction();

        $user = User::find(123);
        $user->update($userDatos);
        $user->perfil()->update($perfilDatos);
        
        DB::commit();
    } 
    catch (\Exception $e) {
        
        DB::rollback();
        
    }
    
```


## Changelog

Please see [CHANGELOG](CHANGELOG.md) for more information on what has changed recently.

## Security Vulnerabilities

Please review [our security policy](../../security/policy) on how to report security vulnerabilities.

## Credits

- [Amilgar Manuel Cortes Soberanes](https://github.com/ImprovingLaborCourts)
- [Fernando Valadez Castillo](https://github.com/ImprovingLaborCourts)
- [Edgar Orozco Juárez](https://github.com/ImprovingLaborCourts)

## License

The MIT License (MIT). Please see [License File](LICENSE.md) for more information.
