<?php

namespace ILC\AdminUsuarios\Database\Providers;

use Carbon\Carbon;
use Faker\Provider\Base as BaseProvider;

class PersonaProvider extends BaseProvider
{
    const VOCALES = ['A', 'E', 'I', 'O', 'U'];

    public function persona($sexo = null)
    {
        $persona = $this->generarPersonaAleatorio($sexo);
        $curp = $this->obtieneCURP($persona);

        $persona['curp'] = $curp;

        return (object) $persona;
    }

    private function generarPersonaAleatorio($sexo = null) {
        // Definimos arreglos con nombres y apellidos ficticios
        $nombresHombres = ["JUAN", "CARLOS", "PEDRO", "DANIEL", "MIGUEL", "JOSÉ", "ANTONIO", "JAVIER", "FRANCISCO", "LUIS", "EDUARDO", "ANDRÉS", "RAÚL", "ALFONSO", "ALEJANDRO", "ENRIQUE", "FERNANDO", "JORGE", "MANUEL", "PABLO", "MARIO", "ADRIÁN", "OSCAR", "EMILIO", "JOSUE", "DAVID", "RAMÓN", "RODRIGO", "GABRIEL", "ROBERTO", "HUMBERTO"];
        $nombresMujeres = ["MARÍA", "ANA", "JUANA", "ISABEL", "ROSA", "PATRICIA", "CARMEN", "MARTA", "LUCÍA", "LAURA", "EVA", "BEATRIZ", "SOFÍA", "ALICIA", "SARA", "TERESA", "CARLOTA", "JOSEFA", "ELISA", "LIDIA", "PAULA", "ESTHER", "VERÓNICA", "JULIA", "ROCÍO", "CONCEPCIÓN", "VICTORIA", "FRANCISCA", "ANDREA", "LUZ", "MERCEDES"];
        $apellidos1 = ['GARCIA', 'MARTINEZ', 'LOPEZ', 'GONZALEZ', 'PEREZ', 'RODRIGUEZ', 'SANCHEZ', 'HERNANDEZ', 'GOMEZ', 'FERNANDEZ', 'DIAZ', 'ALVAREZ', 'MORENO', 'MUÑOZ', 'ROMERO', 'ALONSO', 'GUTIERREZ', 'NAVARRO', 'TORRES', 'MORALES', 'ORTEGA', 'RUIZ', 'RAMOS', 'RIVAS', 'CASTRO', 'SERRANO', 'VICENTE', 'RUBIO', 'ROBLES', 'HERRERO', 'MOLINA', 'FERRER', 'MONTES', 'NUÑEZ', 'CALVO', 'DELGADO', 'VELASCO', 'LOZANO', 'MARIN', 'BLANCO', 'JIMENEZ', 'MENDEZ', 'BENITEZ', 'CASTILLO', 'ORTIZ', 'SANTOS', 'IBAÑEZ'];
        $generos = ['H', 'M'];

        // Seleccionamos un nombre y dos apellidos aleatorios
        if($sexo == null) {
            $sexo = $generos[array_rand([0,1])];
        }

        $nombre = ($sexo == 'H')
            ? $nombresHombres[$this->numberBetween(0, count($nombresHombres) - 1)]
            : $nombresMujeres[$this->numberBetween(0, count($nombresHombres) - 1)];
        $apellido1 = $apellidos1[$this->numberBetween(0, count($apellidos1) - 1)];
        $apellido2 = $apellidos1[$this->numberBetween(0, count($apellidos1) - 1)];
        $fnac = $this->generarFechaAleatoria();
        $fechaNacimiento = $fnac['fecha'];
        $fechaIso = $fnac['iso'];
        $edo = $this->generarEstadoAleatorio();
        $estadoNacimiento = $edo['codigo'];

        // Devolvemos un objeto con el nombre completo y las iniciales de los apellidos
        return [
            'nombreCompleto' => "{$nombre} {$apellido1} {$apellido2}",
            'nombre' => $nombre,
            'apellido1' => $apellido1,
            'apellido2' => $apellido2,
            'fechaNacimiento' => $fechaNacimiento,
            'fechaNacimientoIso' => $fechaIso,
            'sexo' => $sexo,
            'estadoNacimiento' => $estadoNacimiento,
            'estadoNacimientoNombre' => $edo['nombre'],
            'inicialesApellidos' => substr($apellido1, 0, 1) . $this->buscarVocal($apellido1) . substr($apellido2, 0, 1),
        ];
    }

    // Definimos una función para generar una fecha de nacimiento aleatoria entre 1950 y 2020
    private function generarFechaAleatoria()
    {
        $fechaActual = new Carbon();
        $anioActual = $fechaActual->year - 15;
        $anioMinimo = $anioActual - 50; // Se establece una edad máxima de 78 años

        $anioAleatorio = $this->numberBetween($anioMinimo, $anioActual);
        $mesAleatorio = $this->numberBetween(1, 12); // Se genera un nÃºmero aleatorio entre 1 y 12 para el mes
        $mes = new Carbon($anioAleatorio, $mesAleatorio, 0); // Se obtiene el nÃºmero mÃ¡ximo de dÃ­as para el mes y aÃ±o seleccionados
        $diaMaximo = $mes->daysInMonth;
        $diaAleatorio = $this->numberBetween(1, $diaMaximo); // Se genera un número aleatorio entre 1 y el número máximo de días para el mes y año seleccionados
        $fechaAleatoria = new Carbon($anioAleatorio. '-' . $mesAleatorio . '-' . $diaAleatorio); // Se crea un objeto fecha a partir de los valores aleatorios generados

        $fecha = $fechaAleatoria;
        $aniocompleto = $fecha->year;
        $anio = substr($aniocompleto, 2); // Obtiene los Últimos 2 dí­gitos del año
        $mes = str_pad($fecha->month, 2, '0', STR_PAD_LEFT); // Agrega un cero a la izquierda si el mes es menor a 10
        $dia = str_pad($fecha->day, 2, '0', STR_PAD_LEFT); // Agrega un cero a la izquierda si el dÃ­a es menor a 10
        $fechaCurp = $anio . $mes . $dia; // Formatea la fecha en formato YYMMDD

        return ['fecha' => $fechaCurp, 'iso' => $aniocompleto . '-' . $mes . '-' . $dia ];
    }

    private function generarEstadoAleatorio()
    {
        $estados = [
            [ 'nombre' => "Aguascalientes", 'codigo' => "AG" ],
            [ 'nombre' => "Baja California", 'codigo' => "BC" ],
            [ 'nombre' => "Baja California Sur", 'codigo' => "BS" ],
            [ 'nombre' => "Campeche", 'codigo' => "CM" ],
            [ 'nombre' => "Coahuila", 'codigo' => "CO" ],
            [ 'nombre' => "Colima", 'codigo' => "CL" ],
            [ 'nombre' => "Chiapas", 'codigo' => "CS" ],
            [ 'nombre' => "Chihuahua", 'codigo' => "CH" ],
            [ 'nombre' => "Ciudad de México", 'codigo' => "DF" ],
            [ 'nombre' => "Durango", 'codigo' => "DG" ],
            [ 'nombre' => "Guanajuato", 'codigo' => "GT" ],
            [ 'nombre' => "Guerrero", 'codigo' => "GR" ],
            [ 'nombre' => "Hidalgo", 'codigo' => "HG" ],
            [ 'nombre' => "Jalisco", 'codigo' => "JA" ],
            [ 'nombre' => "México", 'codigo' => "MX" ],
            [ 'nombre' => "Michoacán", 'codigo' => "MI" ],
            [ 'nombre' => "Morelos", 'codigo' => "MO" ],
            [ 'nombre' => "Nayarit", 'codigo' => "NA" ],
            [ 'nombre' => "Nuevo León", 'codigo' => "NL" ],
            [ 'nombre' => "Oaxaca", 'codigo' => "OA" ],
            [ 'nombre' => "Puebla", 'codigo' => "PB" ],
            [ 'nombre' => "Querétaro", 'codigo' => "QE" ],
            [ 'nombre' => "Quintana Roo", 'codigo' => "QR" ],
            [ 'nombre' => "San Luis Potosí", 'codigo' => "SL" ],
            [ 'nombre' => "Sinaloa", 'codigo' => "SI" ],
            [ 'nombre' => "Sonora", 'codigo' => "SO" ],
            [ 'nombre' => "Tabasco", 'codigo' => "TB" ],
            [ 'nombre' => "Tamaulipas", 'codigo' => "TM" ],
            [ 'nombre' => "Tlaxcala", 'codigo' => "TL" ],
            [ 'nombre' => "Veracruz", 'codigo' => "VE" ],
            [ 'nombre' => "Yucatán", 'codigo' => "YU" ],
            [ 'nombre' => "Zacatecas", 'codigo' => "ZA" ],
        ];

        $index = $this->numberBetween(0, count($estados) - 1);
        return $estados[$index];
    }

    // Definimos una función para buscar la primera vocal interna de una cadena
    private function buscarVocal($cadena)
    {
        // Recorremos la cadena buscando la primera vocal interna
        for ($i = 1; $i < strlen($cadena); $i++) {
            $caracter = strtoupper(substr($cadena, $i, 1));
            if (in_array($caracter, PersonaProvider::VOCALES)) {
                return $caracter;
            }
        }
        // Si no se encuentra ninguna vocal, se devuelve una "X"
        return 'X';
    }

    private function shuffleFisherYates($array)
    {
        $count = count($array);

        for ($i = $count - 1; $i > 0; $i--) {
            $j = mt_rand(0, $i); // Genera un índice aleatorio entre 0 y $i

            // Intercambia los elementos en las posiciones $i y $j
            $temp = $array[$i];
            $array[$i] = $array[$j];
            $array[$j] = $temp;
        }

        return $array;
    }

    private function generaDigitoVerificador($curp)
    {
        $segRaiz = substr($curp, 0, 17);
        $chrCaracter = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $intFactor = [17];
        $lngSuma = 0.0;
        $lngDigito = 0.0;

        for ($i = 0; $i < 17; $i++) {
            for ($j = 0; $j < 37; $j++) {
                if (substr($segRaiz, $i, $i + 1) == substr($chrCaracter, $j, $j + 1)) {
                    $intFactor[$i] = $j;
                }
            }
        }

        for ($k = 0; $k < 17; $k++) {
            $lngSuma = $lngSuma + (($intFactor[$k]) * (17 - $k + 1));
        }

        $lngDigito = (10 - ($lngSuma % 10));

        if ($lngDigito == 10) {
            $lngDigito = 0;
        }

        return $lngDigito;
    }

    // Definimos una función para generar un CURP a partir de un objeto con los datos de una persona
    private function obtieneCURP($datosPersona) {
        // Extraemos los datos de la persona
        $apellido1 = $datosPersona['apellido1'];
        $apellido2 = $datosPersona['apellido2'];
        $nombre = $datosPersona['nombre'];
        $fechaNacimiento = $datosPersona['fechaNacimiento'];
        $sexo = $datosPersona['sexo'];
        $estadoNacimiento = $datosPersona['estadoNacimiento'];
        $homoclave = $this->generarCaracteresAleatorios();
        // Construimos el CURP a partir de los datos

        $curp = $this->generaCURP($nombre, $apellido1, $apellido2, $fechaNacimiento, $sexo, $estadoNacimiento);

        // Devolvemos el CURP sin DV
        return $curp;
    }

    private function generarCaracteresAleatorios() {
        // Arreglo con los caracteres permitidos
        $caracteres = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
            'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
            'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S',
            'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];

        // Mezclamos el arreglo de caracteres al azar
        $caracteresMezclados = $this->shuffleFisherYates($caracteres);

        // Tomamos los primeros tres caracteres mezclados
        $caracteresSeleccionados = array_slice($caracteresMezclados, 0, 2);

        // Devolvemos los caracteres seleccionados como una cadena
        return implode('', $caracteresSeleccionados);
    }

    private function generaCURP($nom, $pat, $mat, $fecha, $genero, $edo)
    {
        $quitar = '';
        $nombres = '';
        $curp = '';

        $nom = $this->eliminarAcentos(strtoupper($nom));
        $pat = $this->eliminarAcentos(strtoupper($pat));
        $mat = $this->eliminarAcentos(strtoupper($mat));
        $genero = strtoupper($genero);

        $quitar = '/^(DE |DEL |LO |LOS |LA |LAS )+/';
        $nombres = '/^(MARIA |JOSE )/';

        $nom = preg_replace($quitar, '', $nom);
        $nom = preg_replace($nombres, '', $nom);
        $nom = preg_replace($quitar, '', $nom);
        $pat = preg_replace($quitar, '', $pat);
        $mat = preg_replace($quitar, '', $mat);

        if ($mat=='') $mat='X';

        $curp  = substr($pat, 0, 1) . $this->buscaVocal($pat) . substr($mat, 0, 1) . substr($nom, 0, 2);
        $curp  = $this->cambiaPalabra($curp);

        $curp .= $fecha;
        $curp .= $genero . $edo;
        $curp .= $this->buscaConsonante( $pat ) . $this->buscaConsonante( $mat ) . $this->buscaConsonante( $nom ) ;
        $curp .= substr($fecha, 0,1) == '19' ? '0' : 'A';
        $curp .= $this->ultdig( $curp );

        return $curp;
    }

    private function eliminarAcentos($cadena)
    {
        // Reemplazar los caracteres con acentos y diéresis por sus equivalentes sin ellos
        $texto = iconv("UTF-8", "ASCII//TRANSLIT//IGNORE", $cadena);

        return $texto;
    }

    private function buscaVocal($str)
    {
        $vocales = 'AEIOU';
        $i = null;
        $c = null;

        for($i = 1; $i< strlen($str); $i++)	{
            $c = substr($str, $i, 1);
            if (strpos($vocales, $c) !== false) {
                return $c;
            }
        }
        return 'X';
    }

    private function buscaConsonante($str)
    {
        $vocales = 'AEIOUÁÉÍÓÚ';
        for ($i = 1; $i < strlen($str); $i++) {
            $c = $str[$i];
            if (strpos($vocales, $c) === false) {
                return $c;
            }
        }
        return 'X';
    }

    private function cambiaPalabra($str)
    {
        $pal1 = '/BUEI|BUEY|CACA|CACO|CAGA|CAGO|CAKA|CAKO|COGE|COJA|COJE|COJI|COJO|CULO|FETO|GUEY/';
        $pal2 = '/JOTO|KACA|KACO|KAGA|KAGO|KOGE|KOJO|KAKA|KULO|LOCA|LOCO|MAME|MAMO|MEAR|MEAS|MEON/';
        $pal3 = '/MION|MOCO|MULA|PEDA|PEDO|PENE|PUTA|PUTO|QULO|RATA|RUIN/';

        $str = substr($str, 0, 4);

        $val = preg_match($pal1, $str) || preg_match($pal2, $str);
        $val = preg_match($pal3, $str) || $val;

        if ($val) {
            return substr_replace($str, 'X', 1, 1);
        }

        return $str;
    }

    private function ultdig($curp)
    {
        $dv = 0;
        for ($i = 0; $i < strlen($curp); $i++) {
            $c = $this->tabla($curp[$i], ord($curp[$i]));
            $dv += $c * (18 - $i);
        }
        $dv %= 10;
        return ($dv == 0) ? 0 : 10 - $dv;
    }

    private function tabla($i, $x)
    {
        if ($i >= '0' && $i <= '9') {
            return $x - 48;
        } elseif ($i >= 'A' && $i <= 'N') {
            return $x - 55;
        } elseif ($i >= 'O' && $i <= 'Z') {
            return $x - 54;
        } else {
            return 0;
        }
    }

    function validarCURP($curp)
    {
        $reg = "";

        if (strlen($curp) == 18) {
            $digito = $this->verificarCURP($curp);

            $reg = "/[A-Z]{4}\d{6}[HM][A-Z]{2}[B-DF-HJ-NP-TV-Z]{3}[A-Z0-9][0-9]/";

            if (preg_match($reg, $curp)) {
                return false;
            }

            if (!(intval($digito) == intval(substr($curp, 17, 1)))) {
                return false;
            }

            return true;
        } else {
            return false;
        }
    }

    function verificarCURP($curp)
    {
        $segRaiz = substr($curp, 0, 17);
        $chrCaracter = "0123456789ABCDEFGHIJKLMNÑOPQRSTUVWXYZ";
        $intFactor = array_fill(0, 17, 0);
        $lngSuma = 0.0;
        $lngDigito = 0.0;

        for ($i = 0; $i < 17; $i++) {
            for ($j = 0; $j < 37; $j++) {
                if (substr($segRaiz, $i, 1) == substr($chrCaracter, $j, 1)) {
                    $intFactor[$i] = $j;
                }
            }
        }

        for ($k = 0; $k < 17; $k++) {
            $lngSuma += ($intFactor[$k] * (18 - $k));
        }

        $lngDigito = (10 - ($lngSuma % 10));

        if ($lngDigito == 10) {
            $lngDigito = 0;
        }

        return $lngDigito;
    }

}
